using UnityEngine;
using System.Collections;

public class CameraControl : MonoBehaviour {
	
	public GameObject _camera;
	
	// 
	private float x = 135f;
	private float y = 45f;
	private float distance = 3.0f;
	private float minDist = 2.0f;
	private float maxDist = 6.0f;	
	private float xSpeed = 250.0f;
	private float ySpeed = 120.0f;
	private float yMinLimit = 10f;
	private float yMaxLimit = 60;
	
	void Update() {
		if (Input.GetMouseButton(1)){
			x += (float)(Input.GetAxis("Mouse X") * xSpeed * 0.02);
			y -= (float)(Input.GetAxis("Mouse Y") * ySpeed * 0.02);
		}					
		distance += -(Input.GetAxis("Mouse ScrollWheel"));
		if (distance < minDist) distance = minDist;
		if (distance > maxDist) distance = maxDist;
		
		y = ClampAngle(y, yMinLimit, yMaxLimit);
									   
		Quaternion rotation = Quaternion.Euler(y, x, 0);
		Vector3 position = (Vector3)(rotation * new Vector3(0.0f, 0.0f, -distance));
						
		_camera.transform.rotation = rotation;
		_camera.transform.position = position;
    }

	float ClampAngle (float angle, float min, float max) {
        if (angle < -360)
                angle += 360;
        if (angle > 360)
                angle -= 360;
        return Mathf.Clamp (angle, min, max);
	}
}
