using UnityEngine;
using System.Collections;
using System.IO;
using System;

public class LogFile {
	
	private FileInfo _file;
	private string _name;
	private string _filePath = "GameLog\\";

	public LogFile (string _newName) {
		_name = _filePath + thisDate() + _newName + ".log";
		_file = new FileInfo(_name);
		if (!File.Exists(_name)) _file.Create();	
	}
	
	public void AddInfo(string _data) {
		StreamWriter sw = new StreamWriter(File.Open(_name, FileMode.Append, FileAccess.Write));
		sw.WriteLine(_data);
		sw.Close();
	}
	
	public void AddTime(string _data) {
		StreamWriter sw = new StreamWriter(File.Open(_name, FileMode.Append, FileAccess.Write));
		sw.WriteLine(thisTime() + _data);
		sw.Close();
	}
	
	private string thisDate(){
		string temp = "";
		string _date = DateTime.Today.ToString();
		string[] temp2 = new string[3];
		temp2 = _date.Split(new Char [] {'/',' '});
		temp = temp2[2]+"_"+temp2[0]+"_"+temp2[1]+"-";
		return temp;
	}
	
	private string thisTime(){
		string temp = "";
		string _date = DateTime.Now.ToString();
		string[] temp2 = new string[3];
		temp2 = _date.Split(new Char [] {' '});
		temp = temp2[1] + " ";
		return temp;
	}
}
