using UnityEngine;
using System.Collections;

public class Game : MonoBehaviour {
	
	public Object SpherePrefab; //
	
	private GameObject[] Spheres;
	private int[,] sColor; // 
	private int countX = 10;
	private int countY = 9;
	private float constL = -2.6f;
	private float constD = -4f;

	void Start () {
		sColor = new int[countX,countY];
		Spheres = new GameObject[countX*countY];
		int _id = 0;
		
		for (int i=0; i<countX; i++)
		for (int j=0; j<countY; j++)
		{
			SetSphere(new Vector3(constL + i, constD + j,0),_id);
			_id ++;
		}
		Generator();
	}
	
	void Update () {
		for (int i=0; i<countX; i++)
		for (int j=0; j<countY; j++)
		{
			if (sColor[i,j] == 0) {
				Vector3 temp = Spheres[i*countY+j].transform.position;
				Spheres[i*countY+j].transform.position = new Vector3(temp.x, temp.y, 1);
			} else {
				Vector3 temp = Spheres[i*countY+j].transform.position;
				Spheres[i*countY+j].transform.position = new Vector3(temp.x, temp.y, 0);
				Spheres[i*countY+j].renderer.material.color = SphereColor(sColor[i,j]);
			}
		}
		if (Grav() == 0) {Centr();};
	}
	
	// 
	void SetSphere (Vector3 pos, int id) {
		Object temp = Instantiate(SpherePrefab, pos, Quaternion.identity);
		Spheres[id] = (GameObject)temp;
		Spheres[id].GetComponent<Sphere>().ID = id;
	}
	
	void Generator (){
		for (int i=0; i<countX; i++)
		for (int j=0; j<countY; j++)
		{
			sColor[i,j] = Random.Range(1, 5);
		}
	}
	
	Color SphereColor (int i){
		Color temp = Color.white;
		switch (i) 
		{case 1:
			temp = Color.red;
			break;
		case 2:
			temp = Color.green;
			break;
		case 3:
			temp = Color.blue;
			break;
		case 4:
			temp = Color.cyan;
			break;
		case 5:
			temp = Color.magenta;
			break;
		default:
			temp = Color.black;
			break;
		}
		return temp;
	}
	
	//    
	public void Click(int id){
		int x = id / countY;
		int y = id % countY;
		if (sColor[x,y] !=0) 
		if (NotOne(x, y, sColor[x,y])){
			DelSphere(x, y, sColor[x,y]);
		}
	}
	
	//,       
	bool NotOne(int x, int y, int type){
		bool temp = false;
		if (x > 0) if (sColor[x-1,y] == type) {temp = true;}
		if (x < countX-1) if (sColor[x+1,y] == type) {temp = true;}
		if (y > 0) if (sColor[x,y-1] == type) {temp = true;}
		if (y < countY-1) if (sColor[x,y+1] == type) {temp = true;}
		return temp;
	}
	
	//  
	void DelSphere(int x, int y, int type){
		if (sColor[x,y] == type){
			sColor[x,y]  = 0;
			if (x > 0) {DelSphere (x-1,y,type);}
			if (x < countX-1) {DelSphere (x+1,y,type);}
			if (y > 0) {DelSphere (x,y-1,type);}
			if (y < countY-1) {DelSphere (x,y+1,type);}
		}
	}
	
	int Grav(){
		int temp = 0;
		for (int x = 0; x<countX; x++)
		for (int y = 0; y<countY; y++)
		{
			if (y < countY-1){
				if ((sColor[x,y] == 0)&&(sColor[x,y+1] !=0)){
					sColor[x,y] = sColor[x,y+1];
					sColor[x,y+1] = 0;
					temp++;
				}
			}
		}
		return temp;
	}
	
	void Centr(){
		for (int x = 1; x<5; x++)
			if (sColor[x,0] == 0) {
				for (int y= 0; y<countY; y++){
					sColor[x,y] = sColor[x-1,y];
					sColor[x-1,y] = 0;
				}
			}	
		for (int x = 5; x<9; x++)
			if (sColor[x,0] == 0) {
				for (int y= 0; y<countY; y++){
					sColor[x,y] = sColor[x+1,y];
					sColor[x+1,y] = 0;
				}
			}
	}
	
	
}
