using UnityEngine;
using System.Collections;

public class Game : MonoBehaviour {
	
	public GameObject LeftDialog;
	public GameObject RightDialog;
	
	private float _showZ = -3;
	private float _hideZ = 1;
	
	private Rect _leftRect;
	private Rect _rightRect;
	
	private bool _leftF = false;
	private bool _rightF = false;
	
	private string _leftText = "";
	private string _rightText = "";
	
	void Start () {
		_leftRect = new Rect (Screen.width * 0.12f  , Screen.height * 0.7f, 200, 60);
		_rightRect = new Rect (Screen.width * 0.62f , Screen.height * 0.8f, 200, 60);
	}
	
	void Update () {
		switch ((int)Time.time)
		{ case 3:
			_leftText = " ";
			ShowLeft();
			break;
			case 5:
			_leftText = "";
			break;
			case 7:
			_leftText = "   ";
			break;
			case 10:
			_leftText = "";
			_rightText = "   ";
			ShowRight();
			break;
			case 12:
			_rightText = "";
			break;
			case 14:
			_leftText = " ?";
			break;
			case 16:
			_rightText = " - !";
			break;
			case 17:
			_leftText = "  - .";
			break;
			case 18:
			HideRight();
			break;
			case 20:
			_leftText = "  ";
			break;
			case 22:
			_leftText = " ";
			break;
			case 24:
			HideLeft();
			break;
		}
	
	}
	
	void OnGUI () {
		GUI.contentColor = Color.black;
		if (_leftF) {GUI.Label(_leftRect, _leftText);}
		if (_rightF) {GUI.Label(_rightRect, _rightText);}
	}
	
	void ShowLeft(){
		Vector3 temp = LeftDialog.transform.position;
		LeftDialog.transform.position = new Vector3(temp.x, temp.y, _showZ);
		_leftF = true;
	}
	
	void ShowRight(){
		Vector3 temp = RightDialog.transform.position;
		RightDialog.transform.position = new Vector3(temp.x, temp.y, _showZ);
		_rightF = true;
	}
	
	void HideLeft(){
		Vector3 temp = LeftDialog.transform.position;
		LeftDialog.transform.position = new Vector3(temp.x, temp.y, _hideZ);
		_leftF = false;
	}
	
	void HideRight(){
		Vector3 temp = RightDialog.transform.position;
		RightDialog.transform.position = new Vector3(temp.x, temp.y, _hideZ);
		_rightF = false;
	}
}
